import os
import subprocess
import sys
import os.path


#setup the following path to dmfit executable and to wine executablefor linux and mac os x
WIN_app_path=r'C:\Program Files\pissNMRprocessor\application\pissFA.exe' 
WIN_mcr_path=r'C:\Program Files\Matlab\MATLAB Runtime\v910\runtime\win64'

LIN_app_path=r'/home/nmrsu/Documents/pissNMRFISTAapp_v2/pissNMRprocessorReg/for_redistribution_files_only/run_pissNMRprocessorReg_v2.sh'
LIN_mcr_path=r'/home/nmrsu/MatlabRuntime/R2022b/'  # for Centos 7
#LIN_mcr_path=r'/usr/local/MATLAB/MATLAB_Compiler_Runtime/v81' # for Centos 5

MAC_app_path=r'/Applications/pissNMRprocessor/application/pissFA.app'
MAC_mcr_path=r'/Applications/MATLAB/MATLAB_Runtime/v92/'


def get_os_version():
    ver = sys.platform.lower()
    if ver.startswith('java'):
        import java.lang
        ver = java.lang.System.getProperty("os.name").lower()
    return ver

OS=get_os_version()


if OS.startswith('mac'):
    # for Mac
    mcr_location=os.path.normpath(MAC_mcr_path)
    home=os.getenv("HOME")
    app_location=os.path.normpath(MAC_app_path)
elif OS.startswith('linux'):
    # for Linux
		app_location=os.path.normpath(LIN_app_path)
		mcr_location=os.path.normpath(LIN_mcr_path)
else:
 # that's windows
			app_location=os.path.normpath(WIN_app_path)
			mcr_location=os.path.normpath(WIN_mcr_path)
			

#TS 2 :  [EXPNAME, EXPNO, PROCNO, DIR, USER]
#TS >3 : [EXPNAME, EXPNO,PROC, DIR]
# topspin 2- or 3+
dtset=CURDATA()
if dtset == None:
	MSG("Please open a bssfpNMR dataset!")
	EXIT()

if len(dtset)==5: # for topspin 2-
	dtset[3]=os.path.join(dtset[3],"data",dtset[4],"nmr")

 
datfile=os.path.join(dtset[3],dtset[0],dtset[1])

os.environ['PATH'] = os.environ['PATH'] +os.pathsep +mcr_location
if OS.startswith('linux') or OS.startswith('mac'):
	subprocess.call([app_location,mcr_location,datfile])
else:
	subprocess.call([app_location,datfile])