function []=create_outd(pdata_dir)

filename=[pdata_dir,filesep,'outd'];
%% read the  file
% fileID=fopen(filename,'r');
% [~,~,machinefmt,~] = fopen(fileID);
% formatSpec = '%s%[^\n\r]';
% dataArray = textscan(fileID, formatSpec, 'Delimiter', '', 'WhiteSpace', '',  'ReturnOnError', false);
% %% Remove white space around all cell columns.
% dataArray{1} = dataArray{1};
% fclose(fileID);
% clearvars fileID;

pdata_dir_lin =  strrep(pdata_dir,filesep,'/');

dataArray{1,1} = {'##TITLE= Parameter file, TopSpin 4.3.0';...
    '##JCAMPDX= 5.0';...
    '##DATATYPE= Parameter Values';...
    ['##NPOINTS= 1' char(9) '$$ modification sequence number'];...
    '##ORIGIN= Bruker BioSpin GmbH';...
    '##OWNER= User';'$$ 2023-12-14 14:59:38.125 +0100  User@PC-Max';...
    ['$$ ' pdata_dir_lin '/outd'];...
    '$$ process C:\Bruker\TopSpin4.3.0\prog\mod\proc1d.exe';...
    '##$CURPLOT= <no printer>';...
    '##$CURPRIN= <peaklist>';...
    '##$DFORMAT= <normdp>';...
    '##$LAYOUT= <+/1D_H.xwp>';...
    '##$LFORMAT= <normlp>';...
    '##$PFORMAT= <normpl>';...
    '##END='};

machinefmt = 'ieee-le';

%% Write new file
% warning off MATLAB:iofun:UnsupportedEncoding;
% fileID = fopen(filename, 'w', 'b', 'UTF16-LE');
fileID=fopen(filename,'w',machinefmt);
formatSpec = '%s\n';
for ind = 1:size(dataArray{1,1},1)
    fprintf(fileID,formatSpec,dataArray{1, 1}{ind, 1});
end
fclose(fileID);
end


