function varargout = generic_merge_well_gui(varargin)
% GENERIC_MERGE_WELL_GUI MATLAB code for generic_merge_well_gui.fig
%      GENERIC_MERGE_WELL_GUI, by itself, creates a new GENERIC_MERGE_WELL_GUI or raises the existing
%      singleton*.
%
%      H = GENERIC_MERGE_WELL_GUI returns the handle to a new GENERIC_MERGE_WELL_GUI or the handle to
%      the existing singleton*.
%
%      GENERIC_MERGE_WELL_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GENERIC_MERGE_WELL_GUI.M with the given input arguments.
%
%      GENERIC_MERGE_WELL_GUI('Property','Value',...) creates a new GENERIC_MERGE_WELL_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before generic_merge_well_gui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to generic_merge_well_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help generic_merge_well_gui

% Last Modified by GUIDE v2.5 17-Nov-2011 14:49:55

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @generic_merge_well_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @generic_merge_well_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before generic_merge_well_gui is made visible.
function generic_merge_well_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to generic_merge_well_gui (see VARARGIN)

% Choose default command line output for generic_merge_well_gui
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes generic_merge_well_gui wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = generic_merge_well_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit_range1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_range1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_range1 as text
%        str2double(get(hObject,'String')) returns contents of edit_range1 as a double


% --- Executes during object creation, after setting all properties.
function edit_range1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_range1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_range2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_range2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_range2 as text
%        str2double(get(hObject,'String')) returns contents of edit_range2 as a double


% --- Executes during object creation, after setting all properties.
function edit_range2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_range2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_jump_Callback(hObject, eventdata, handles)
% hObject    handle to edit_jump (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_jump as text
%        str2double(get(hObject,'String')) returns contents of edit_jump as a double


% --- Executes during object creation, after setting all properties.
function edit_jump_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_jump (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_input_folder_Callback(hObject, eventdata, handles)
% hObject    handle to edit_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_input_folder as text
%        str2double(get(hObject,'String')) returns contents of edit_input_folder as a double


% --- Executes during object creation, after setting all properties.
function edit_input_folder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_input_folder.
function pushbutton_input_folder_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

directory_name = uigetdir('','Select Input Folder');
if directory_name~=0
    set(handles.edit_input_folder,'string',directory_name);
end


function edit_output_folder_Callback(hObject, eventdata, handles)
% hObject    handle to edit_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_output_folder as text
%        str2double(get(hObject,'String')) returns contents of edit_output_folder as a double


% --- Executes during object creation, after setting all properties.
function edit_output_folder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_output_folder.
function pushbutton_output_folder_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

directory_name = uigetdir('','Select Output Folder');
if directory_name~=0
    set(handles.edit_output_folder,'string',directory_name);
end

% --- Executes on button press in pushbutton_merge.
function pushbutton_merge_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_merge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inputfolder=strtrim(get(handles.edit_input_folder,'string'));
if ~isdir(inputfolder)
    errordlg('Input folder not found','Folder Error','modal');
    return;
end

outputfolder=strtrim(get(handles.edit_output_folder,'string'));
if ~isdir(outputfolder)
    errordlg('Output folder not found','Folder Error','modal');
    return;
end

% range1 = str2num(get(handles.edit_range1,'string'));
% range2 = str2num(get(handles.edit_range2,'string'));
% jump = str2num(get(handles.edit_jump,'string'));

num_of_rows_sub_pic=str2num(get(handles.edit_num_of_rows,'string'));
num_of_cols_sub_pic=str2num(get(handles.edit_num_of_cols,'string'));

folders=dir(inputfolder);

for i=3:length(folders)
   output_merge_folder=fullfile(outputfolder,[folders(i).name '_merge']);
   mkdir(output_merge_folder);
   merge_files_in_folder(folders(i).name,fullfile(inputfolder,folders(i).name), ...
       output_merge_folder, num_of_rows_sub_pic, num_of_cols_sub_pic)
end

msgbox('The results can be viewed on the output folder.','Analysis finished','modal');



function edit_num_of_rows_Callback(hObject, eventdata, handles)
% hObject    handle to edit_num_of_rows (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_num_of_rows as text
%        str2double(get(hObject,'String')) returns contents of edit_num_of_rows as a double


% --- Executes during object creation, after setting all properties.
function edit_num_of_rows_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_num_of_rows (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_num_of_cols_Callback(hObject, eventdata, handles)
% hObject    handle to edit_num_of_cols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_num_of_cols as text
%        str2double(get(hObject,'String')) returns contents of edit_num_of_cols as a double


% --- Executes during object creation, after setting all properties.
function edit_num_of_cols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_num_of_cols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
