function merge_files_in_folder(inner_input_folder,input_folder,output_merge_folder, num_of_rows_sub_pic, num_of_cols_sub_pic)


num_of_sub_pic=num_of_rows_sub_pic*num_of_cols_sub_pic;


files=dir(fullfile(input_folder,'*--P00*'));

i=1;

sub_pics=cell(num_of_rows_sub_pic, num_of_cols_sub_pic);

while i+num_of_sub_pic-1<=length(files)
    if is_sub_pic_group(files(i:i+num_of_sub_pic-1))
        
        for k=1:num_of_cols_sub_pic
            for j=1:num_of_rows_sub_pic
                sub_pics{j,k}=imread(fullfile(input_folder,files(i+num_of_rows_sub_pic*(k-1)+j-1).name));
            end
        end
        
        im1234 = merg2x2well(sub_pics);
        
        [~,file_name]=fileparts(files(i).name);
        idx=strfind(file_name,'--');
        well_str=file_name(idx(1)+2:idx(2)-1);
        output_file=[file_name(1:idx(1)-1) '_' inner_input_folder '_' well_str '.jpg'];
        
        h=figure('visible','off');
        
        imshow(im1234,'border','tight')
        set(h,'paperpositionmode','auto')
        print(h,'-djpeg','-r300',fullfile(output_merge_folder,output_file));
        close(h);
        i=i+num_of_sub_pic;
    else
        i=i+1;
    end
end