function av_width=calc_plot_mean_gap_width_step2_movie_v3(filename,std4_th,max_width,font_size,middle_subframe2, midgap_start, flag_save_images)


flag_t0=~isempty(strfind(filename,'_0h_'));

I_orig = imread(filename);

if ndims(I_orig)==3
    I_orig=rgb2gray(I_orig);
end
    
[N,M]=size(I_orig);

borders=[round(N*0.15),round(N*0.85)];

av_width=sum(middle_subframe2(:)==0)/length(middle_subframe2(:,1));
bw= edge(middle_subframe2);

if flag_t0
    edge_x=cell(length(middle_subframe2(:,1)),1);
    for i=1:length(middle_subframe2(:,1))
        edge_x{i}=find(bw(i,:)==1);
    end
    yy=cellfun(@length,edge_x);
    
    if std(yy)>1
        h=floor(length(middle_subframe2(:,1))/10);
        tmp=middle_subframe2(1:1+h-1,:);
        blackarea=sum(tmp(:)==0);
        av_width_vec(1)=blackarea/h;
        for jj=2:10
            tmp=middle_subframe2(1+h*(jj-1):jj*h,:);
            blackarea=sum(tmp(:)==0);
            av_width_vec(jj)=blackarea/h;
        end
        if std(av_width_vec)>std4_th
            av_width=nan;
        end
    end
end

if ~flag_save_images
    return;
end


% % % % % % % % % % % % % % % % % % % % % 


IBW=[false(borders(1)-1,M);[false(length(middle_subframe2(:,1)),midgap_start-1)...
    ,middle_subframe2,false(length(middle_subframe2(:,1)),M-midgap_start-max_width)];false(N-borders(2),M)];
B = bwboundaries(IBW);
bw= edge(IBW);
imshow(I_orig,'border','tight');
hold on;
for i=1:length(B)
    plot(B{i}(:,2),B{i}(:,1),'g','linewidth',2);
end
%axis tight
plot([midgap_start,midgap_start+max_width],borders(1)*[1,1],'r','linewidth',1);
plot([midgap_start,midgap_start+max_width],(borders(2)+1)*[1,1],'r','linewidth',1);
plot(midgap_start*[1,1],borders,'r','linewidth',1);
plot((midgap_start+max_width)*[1,1],borders,'r','linewidth',1);
ymid=round(borders(1)+diff(borders)/2);
x=find(bw(ymid,:));
if isempty(x)
    x=find(bw(borders(1)+5,:));
    ymid=borders(1)+5;
end
if isempty(x)
    x=round([M/2-20,M/2-20]);
end
%plot(x,ones(length(x),1)*ymid,'m','linewidth',2)
ht=text(max_width/2,100,['Average width=',num2str(av_width)]);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','y','HorizontalAlignment','center','VerticalAlignment','bottom');
tstring=regexprep(filename,'_','-');
[~, tstring]=fileparts(tstring);

ht=text(max_width/2,15,tstring);
set(ht,'fontsize',font_size,'FontWeight','demi','Color','r','HorizontalAlignment','center','VerticalAlignment','top','BackgroundColor','y');




