function genPlotsVarTrueHeightFFT(MSDC,Mfunc,h_tArr)
% Generate plots of MSD vs. variable true height for different
% parameter-choice methods. If multiple noise realizations were tested on
% each example and the cells of MSDC contain arrays, the user should supply
% a function Mfunc to apply to each array such as mean or median.
% Inputs:   * MSDC - a cell array containing MSD values for different
% methods, examples and heights. Supposed to be output of
% compareMethodsVariableTrueHeight function.
%           * Mfunc - function to apply in case of multiple noise
%           realizations to each dataset in MSDC. Usually @mean, @median or
%           @min.
%           * h_tArr - array of true heights at which reconstructions were
%           performed. Refer to compareMethodsVariableTrueHeight for
%           values.

MSDC = cellfun(Mfunc,MSDC,'UniformOutput',0);
for jj=1:size(MSDC,1)
    y_min = zeros(4,1); y_max = zeros(4,1);
    h = cell(4,1);
    figure,hold on
    for kk=[1,2,4,5]
        switch kk
            case 1
                st = 'b-+';
            case 2
                st = 'b-x';
            case 4
                st = 'r-*';
            case 5
                st = 'r-^';
        end
        temp = reshape(cell2mat(MSDC(jj,kk,:)),[],1);
        h{kk==[1,2,4,5]}=semilogy(h_tArr(1:2:end),temp(1:2:end),st,'LineWidth',1.2,'markersize',10);
        y_min(kk==[1,2,4,5])=min(temp);
        y_max(kk==[1,2,4,5])=max(temp);
        
    end
    legend([h{:}],{'MSD (1)', 'MSD (2)', 'MSD (3)', 'MSD (4)'},'location','best','edgecolor','w')
    ylabel('MSD'), xlabel('h_{true} (\mum)')
    set(gca,'ylim',[min(y_min), min(max(y_max),10)])
    set(gca,'xlim',[min(h_tArr) max(h_tArr)])
    set(gca,'fontsize',24)
    st = [char(find([4:6,7:9,1:3]==jj)+'a'-1)];
    pos = [0.21    0.75    0.05    0.16];
    annotation('textbox',pos,'String',st,'FitBoxToText','on','FontWeight','bold','linestyle','none','fontsize',30)
end