function generateBoxPlotsREGU(MSDC)
% Generate boxplots for MSD values of the direct and stream function
% methods for different examples and parameter-choice methods.
% Inputs:   * MSDC - cell array containing MSD values for different
%           examples and parameter-choice methods. It is assumed MSDC is 
%           the output of CompareMethods routine.

methods = {'(1)','(2)','(3)','(4)','(5)','(6)'};
for ii=1:size(MSDC,1)
    figure,boxplot(cell2mat(MSDC(ii,:,1)),'Labels',methods)
    ylabel('MSD')
    warning('off','MATLAB:Axes:NegativeLimitsInLogAxis')
    set(gca,'FontSize',24)
    st = [char(find([4:6,7:9,10:12,1:3]==ii)+'a'-1)];
    pos = [0.265    0.775    0.467    0.131];
    annotation('textbox',pos,'String',st,'FitBoxToText','on','linestyle','none','fontsize',30)
end
