function [u,v] = generateShiftedFreqGrid(sz,px)
% Generate Fourier-space grid with zero-centering.
%   Inputs: * sz - vector representing size of the physical space so that
%               sz(1) is number rows and sz(2) is number of columns.
%           * px - vector representing size of each pixel in pre-defined units such that px(1)
%               is size along rows and px(2) is size along the columns.
%   Outputs: * [u,v] - meshgrid-style matrices for Fourier-space. u
%               increases along coluns whereas v increases along rows.

if mod(sz(1),2)==0
    v = [0:(sz(1)/2 -1) -sz(1)/2:-1]';
else
    v = [0:(sz(1)-1)/2 -(sz(1)-1)/2:-1]';
end

if mod(sz(2),2)==0
    u = [0:(sz(2)/2 -1) -sz(2)/2:-1];
else
    u = [0:(sz(2)-1)/2 -(sz(2)-1)/2:-1];
end

u = repmat(u,length(v),1)./(sz(2)*px(2));
v = repmat(v,1,size(u,2))./(sz(1)*px(1));